/**
 * 
 */
package simulator;

import service.ServiceFactory;
import service.SimpleTransition;
import service.SimpleState;
import service.TransitionSystem;
import simulator.plus.SimulationPlusImpl;

/**
 * @author daniele
 *
 */
public class SimulationFactoryImpl implements SimulationFactory {

	public Simulation createSimulationStandard(TransitionSystem<SimpleState, SimpleTransition> target,
			TransitionSystem<SimpleState, SimpleTransition>[] availableServices) throws Exception {
		return SimulationStandardImpl.generate(target, availableServices);
	}

	
	/* (non-Javadoc)
	 * @see simulator.SimulationFactory#createSimulationPlus(service.TransitionSystem, service.TransitionSystem<service.SimpleState,service.SimpleAction>[], service.ServiceFactory)
	 */
	@Override
	public SimulationPlusImpl createSimulationPlus(
			TransitionSystem<SimpleState, SimpleTransition> target,
			TransitionSystem<SimpleState, SimpleTransition>[] availableServices,
			ServiceFactory serviceFactory) throws Exception {
		// TODO Auto-generated method stub
		return SimulationPlusImpl.generate(target, availableServices,serviceFactory);
	}

}
